<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate the API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // SQL query to fetch all notices
    $sql = "SELECT id, Title, Price, Price_OFF, Link, User_Name, Pasword, VPN_APP_link, Details, Image FROM Dollar_Card ORDER BY id DESC";
    $result = $conn->query($sql);

    if ($result === false) {
        throw new Exception($conn->error);
    }

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    // Return success JSON with all notices
    echo json_encode(['status' => 'success', 'data' => $data]);

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}