<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');


try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['API__K_E_Y'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    date_default_timezone_set('Asia/Dhaka');

    // SQL query to fetch data
    $sql = "SELECT id, User_ID, Root_Amount, Total_amount, Date, Status, Note, Trx_ID, Bank_Name, Bank_Address, Account_holder_Name, Account_number, Visa_Master_card_number FROM Bank_Request_history";
    $result = $conn->query($sql);

    if ($result === false) {
        throw new Exception($conn->error);
    }

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    // Return success JSON
    echo json_encode(['status' => 'success', 'data' => $data]);

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>