<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Debugging log for received JSON request
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 2: Validate and Decrypt ID
$encrypted_id = $requestData['ID'] ?? '';
if (empty($encrypted_id)) {
    echo json_encode(['status' => 'error', 'message' => 'ID is required']);
    exit();
}

$id = decryptData($encrypted_id);
if (empty($id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt ID']);
    exit();
}

// Step 3: Check If Record Exists Before Deleting
$checkRecordSql = "SELECT id FROM Drive_Offer WHERE id = ?";
$stmtCheckRecord = $conn->prepare($checkRecordSql);
$stmtCheckRecord->bind_param("i", $id);
$stmtCheckRecord->execute();
$resultCheckRecord = $stmtCheckRecord->get_result();
$stmtCheckRecord->close();

if ($resultCheckRecord->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'Record not found']);
    exit();
}

// Step 4: Delete the Record
$deleteSql = "DELETE FROM Drive_Offer WHERE id = ?";
$stmtDelete = $conn->prepare($deleteSql);
$stmtDelete->bind_param("i", $id);

if ($stmtDelete->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Record deleted successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to delete record']);
}

$stmtDelete->close();
$conn->close();
?>
