<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Notice ID
    $notice_id = $_POST['id'] ?? '';
    if (empty($notice_id)) {
        throw new Exception('Notice ID is required.');
    }

    // Delete query
    $sql = "DELETE FROM Binance_add_money_details WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $notice_id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Notice deleted successfully.']);
    } else {
        throw new Exception('Failed to delete notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
