<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    

    // Get Notice ID
    $notice_id = $_POST['id'] ?? '';
    if (empty($notice_id)) {
        throw new Exception('Notice ID is required.');
    }

    // Delete query
    $sql = "DELETE FROM Admin_Login WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $notice_id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Admin deleted successfully.']);
    } else {
        throw new Exception('Failed to delete notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
