<?php
header('Content-Type: application/json; charset=utf-8');


include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Get POST data
    $api_key = $_POST['api_key'] ?? null;
    $encrypted_id = $_POST['id'] ?? null;

    // Validate API key
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Decrypt the user ID
    if (!$encrypted_id) {
        throw new Exception("User ID is required.");
    }
    $user_id = decryptData($encrypted_id);

    // Check if user exists
    $checkStmt = $conn->prepare("SELECT id FROM USER_DATABSE_PIN WHERE id = ?");
    $checkStmt->bind_param("i", $user_id);
    $checkStmt->execute();
    $checkResult = $checkStmt->get_result();
    if ($checkResult->num_rows == 0) {
        throw new Exception("User not found.");
    }
    $checkStmt->close();

    // Delete user
    $deleteStmt = $conn->prepare("DELETE FROM USER_DATABSE_PIN WHERE id = ?");
    $deleteStmt->bind_param("i", $user_id);

    if ($deleteStmt->execute()) {
        echo json_encode(["status" => "success", "message" => "User deleted successfully."]);
    } else {
        throw new Exception("Failed to delete user.");
    }

    $deleteStmt->close();
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
} finally {
    $conn->close();
}
