<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

$response = array();

// Read JSON Input
$input = json_decode(file_get_contents("php://input"), true);
if (!$input) {
    $input = $_POST;
}

// Required fields
$requiredFields = [
    'fName','lName','email','phone','pin','password','balance','verify',
    'total_deposit','total_spend','block_user','device_login','reward_point',
    'ban_from_add_money','device_id_name'
];

// Check missing fields
foreach ($requiredFields as $field) {
    if (!isset($input[$field]) || $input[$field] === '') {
        echo json_encode([
            'status' => 'error',
            'message' => "Missing or empty field: $field"
        ]);
        exit;
    }
}

// Sanitize Inputs
$fName         = mysqli_real_escape_string($conn, $input['fName']);
$lName         = mysqli_real_escape_string($conn, $input['lName']);
$email         = mysqli_real_escape_string($conn, $input['email']);
$phone         = mysqli_real_escape_string($conn, $input['phone']);
$pin           = mysqli_real_escape_string($conn, $input['pin']);
$password      = mysqli_real_escape_string($conn, $input['password']);
$balance       = (float) mysqli_real_escape_string($conn, $input['balance']);

$verify        = mysqli_real_escape_string($conn, $input['verify']);
$total_deposit = mysqli_real_escape_string($conn, $input['total_deposit']);
$total_spend   = mysqli_real_escape_string($conn, $input['total_spend']);
$block_user    = mysqli_real_escape_string($conn, $input['block_user']); // maps to DB column `Block`
$device_login  = mysqli_real_escape_string($conn, $input['device_login']);
$reward_point  = mysqli_real_escape_string($conn, $input['reward_point']);
$ban_from_add_money = mysqli_real_escape_string($conn, $input['ban_from_add_money']);
$device_id_name = mysqli_real_escape_string($conn, $input['device_id_name']);

// Step 2: Get Account_Create_Bonus_Amount
$settingResult = $conn->query("SELECT Account_Create_Bonus_Amount FROM App_Setting LIMIT 1");
if ($settingResult->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'App settings not found.']);
    exit;
}
$accountCreateBonus = (float) $settingResult->fetch_assoc()['Account_Create_Bonus_Amount'];

// Step 3: Final balance
$finalBalance = $balance + $accountCreateBonus;

// Step 4: Update App_Setting_2 totals
$app2 = $conn->query("SELECT Total_Bonus_Amount, Today_Total_Bonus_Amount FROM App_Setting_2 LIMIT 1")->fetch_assoc();
$new_total_bonus = $app2['Total_Bonus_Amount'] + $accountCreateBonus;
$new_today_bonus = $app2['Today_Total_Bonus_Amount'] + $accountCreateBonus;

$conn->query("UPDATE App_Setting_2 SET 
    Total_Bonus_Amount = '$new_total_bonus',
    Today_Total_Bonus_Amount = '$new_today_bonus'");

// Step 5: Generate unique referral code
function generateRefferCode($length = 6) {
    $numbers = "0123456789";
    $code = "";
    for ($i = 0; $i < $length; $i++) {
        $code .= $numbers[rand(0, strlen($numbers) - 1)];
    }
    return $code;
}
$myRefferCode = generateRefferCode();
while (mysqli_num_rows(mysqli_query($conn, "SELECT My_Reffer_Code FROM USER_DATABSE_PIN WHERE My_Reffer_Code = '$myRefferCode'")) > 0) {
    $myRefferCode = generateRefferCode();
}

// Step 6: Defaults
$Who_invite_reffer_code = 0;
$Joining_date = date("Y-m-d H:i:s");
$FCM_Token = "0";
$Selfi_photo = "0";
$Nid_Front = "0";
$Nid_Back = "0";

// Step 7: Encrypt sensitive fields before insert
$encryptedEmail    = encryptSensitive($email);
$encryptedPhone    = encryptSensitive($phone);
$encryptedPIN      = encryptSensitive($pin);
$encryptedPassword = encryptSensitive($password);
$encryptedBalance  = encryptSensitive($finalBalance);
$encryptedReward   = encryptSensitive($reward_point);

// Step 8: Insert user
$sql = "INSERT INTO USER_DATABSE_PIN 
        (Frist_Name, Last_Name, Email, Phone_number, PIN, User_Password, Balance,
         My_Reffer_Code, Who_invite_reffer_code, Joining_date,
         Veryfi_Status, Total_Deposit, Total_Spend,
         FCM_Token, Selfi_photo, Nid_Front, Nid_Back,
         Block, Device_login, Reward, Ban_From_Add_money, Device_ID_Name)
        VALUES 
        ('$fName', '$lName', '$encryptedEmail', '$encryptedPhone', '$encryptedPIN', '$encryptedPassword', '$encryptedBalance',
         '$myRefferCode', '$Who_invite_reffer_code', '$Joining_date',
         '$verify', '$total_deposit', '$total_spend',
         '$FCM_Token', '$Selfi_photo', '$Nid_Front', '$Nid_Back',
         '$block_user', '$device_login', '$encryptedReward', '$ban_from_add_money', '$device_id_name')";

if (mysqli_query($conn, $sql)) {
    echo json_encode([
        'status' => 'success',
        'message' => 'User created successfully',
        'my_reffer_code' => $myRefferCode,
        'final_balance' => $finalBalance
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => mysqli_error($conn)
    ]);
}
?>