<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';

// Encryption helpers (Database encryption)
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

try {
    // Read POST data
    $api_key          = $_POST['api_key'] ?? '';
    $id               = $_POST['id'] ?? '';
    $user_id          = $_POST['idd'] ?? '';
    $status           = $_POST['status'] ?? '';
    $encrypted_amount = $_POST['Amount'] ?? '';

    // Validate API key
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Decrypt amount
    $alpha_amount = decryptData($encrypted_amount);
    if (!is_numeric($alpha_amount)) {
        throw new Exception("Invalid amount format.");
    }

    // Check if the transaction is already cancelled
    $check_sql = "SELECT Status FROM Reward_Recharge_Request WHERE id = ?";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $check_result = $stmt->get_result();

    if ($check_result->num_rows === 0) {
        throw new Exception("Transaction not found.");
    }

    $row = $check_result->fetch_assoc();
    if (strtolower($row['Status']) === 'cancel') {
        echo json_encode(['status' => 'success', 'message' => 'Already cancelled, no update needed.']);
        exit;
    }

    // Get current reward balance and FCM token
    $balance_sql = "SELECT Reward, FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmt = $conn->prepare($balance_sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $balance_result = $stmt->get_result();

    if ($balance_result->num_rows === 0) {
        throw new Exception("User not found.");
    }

    $user = $balance_result->fetch_assoc();

    // 🔑 Decrypt reward before math
    $current_reward = !empty($user['Reward']) ? (float) decryptSensitive($user['Reward']) : 0.0;
    $new_reward     = $current_reward + (float)$alpha_amount;
    $fcm_token      = $user['FCM_Token'];

    // 🔒 Encrypt new reward before saving
    $encryptedNewReward = encryptSensitive($new_reward);

    // Update user reward balance
    $update_balance_sql = "UPDATE USER_DATABSE_PIN SET Reward = ? WHERE id = ?";
    $stmt = $conn->prepare($update_balance_sql);
    $stmt->bind_param("si", $encryptedNewReward, $user_id);
    $stmt->execute();

    // Update transaction status
    $update_status_sql = "UPDATE Reward_Recharge_Request SET Status = ? WHERE id = ?";
    $stmt = $conn->prepare($update_status_sql);
    $stmt->bind_param("si", $status, $id);
    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'User reward and status updated.']);
    
    
    
// Step 9: Send FCM notification (optional)
if (!empty($fcm_token) && strlen($fcm_token) > 100) {
    $accessToken = getAccessToken('service-account-file.json');

  $title = "Reward Recharge Cancelled";
        $body  = "Your reward recharge request has been cancelled." . number_format($alpha_amount, 2) . " has been refunded to your reward balance.";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode(['message' => ['token' => $fcm_token, 'data' => $datamsg]]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        error_log("FCM Send Error: " . curl_error($ch));
    } else {
        error_log("FCM Response: " . $fcmResponse);
    }
    curl_close($ch);
}

// Step 10: Return Success Response
echo json_encode(['status' => 'success', 'message' => 'Transaction and earnings updated successfully']);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>