<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

try {
    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get NID Request ID
    $nid_id = $_POST['id'] ?? '';
    if (empty($nid_id)) {
        throw new Exception('NID request ID is required.');
    }

    // Get User_ID from NID_Verify_Request
    $getUserSql = "SELECT User_ID FROM NID_Verify_Request WHERE id = ?";
    $stmtUser = $conn->prepare($getUserSql);
    $stmtUser->bind_param("s", $nid_id);
    $stmtUser->execute();
    $resultUser = $stmtUser->get_result();
    if ($resultUser->num_rows === 0) {
        throw new Exception('No user found for this NID request.');
    }
    $userRow = $resultUser->fetch_assoc();
    $user_id = $userRow['User_ID'];
    $stmtUser->close();

    // Get FCM token from User_Database
    $getFcmSql = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmtFcm = $conn->prepare($getFcmSql);
    $stmtFcm->bind_param("i", $user_id);
    $stmtFcm->execute();
    $resultFcm = $stmtFcm->get_result();
    if ($resultFcm->num_rows === 0) {
        throw new Exception('FCM token not found for user.');
    }
    $user = $resultFcm->fetch_assoc();
    $fcm_token = $user['FCM_Token'];
    $stmtFcm->close();

    // Update `Status` to "Cancel" in `NID_Verify_Request`
    $updateNidSql = "UPDATE NID_Verify_Request SET Status = 'Cancel' WHERE id = ?";
    $stmtNid = $conn->prepare($updateNidSql);
    $stmtNid->bind_param("s", $nid_id);
    if (!$stmtNid->execute()) {
        throw new Exception('Failed to update NID verification status.');
    }
    $stmtNid->close();

    // Send FCM notification
    if (strlen($fcm_token) > 100) {
        $accessToken = getAccessToken('service-account-file.json');

        $title = "NID Verification Cancelled";
        $body = "Your NID verification request has been cancelled. Please try again or contact support.";

        $payload = json_encode([
            'message' => [
                'token' => $fcm_token,
                'notification' => [
                    'title' => $title,
                    'body' => $body
                ]
            ]
        ]);

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $fcmResponse = curl_exec($ch);
        if ($fcmResponse === FALSE) {
            error_log("FCM Send Error: " . curl_error($ch));
        } else {
            error_log("FCM Response: " . $fcmResponse);
        }

        curl_close($ch);
    } else {
        error_log("Invalid FCM token for user ID: $user_id");
    }

    // Return success response
    echo json_encode(['status' => 'success', 'message' => 'NID verification request canceled and user notified.']);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
