<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
  require 'get-access-token.php';
try {
    // Read POST data
    $api_key          = $_POST['api_key'] ?? '';
    $id               = $_POST['id'] ?? '';
    $user_id          = $_POST['idd'] ?? '';
    $status           = $_POST['status'] ?? '';
    $encrypted_amount = $_POST['Amount'] ?? '';

    // Validate API key
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Decrypt amount
    $alpha_amount = decryptData($encrypted_amount);
    if (!is_numeric($alpha_amount)) {
        throw new Exception("Invalid amount format.");
    }

    // Check if the transaction is already cancelled
    $check_sql = "SELECT Status FROM Dollar_card_buy_History WHERE id = ?";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $check_result = $stmt->get_result();

    if ($check_result->num_rows === 0) {
        throw new Exception("Transaction not found.");
    }

    $row = $check_result->fetch_assoc();
    if (strtolower($row['Status']) === 'cancel') {
        echo json_encode(['status' => 'success', 'message' => 'Already cancelled, no update needed.']);
        exit;
    }

    // Get current balance of the user (encrypted in DB)
    $balance_sql = "SELECT Balance FROM USER_DATABSE_PIN WHERE id = ?";
    $stmt = $conn->prepare($balance_sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $balance_result = $stmt->get_result();

    if ($balance_result->num_rows === 0) {
        throw new Exception("User not found.");
    }

    $user = $balance_result->fetch_assoc();

    // 🔑 Decrypt balance before math
    $current_balance = !empty($user['Balance']) ? (float) decryptSensitive($user['Balance']) : 0.0;
    $new_balance     = $current_balance + (float)$alpha_amount;

    // 🔒 Encrypt new balance before saving
    $encryptedNewBalance = encryptSensitive($new_balance);

    // Update user balance
    $update_balance_sql = "UPDATE USER_DATABSE_PIN SET Balance = ? WHERE id = ?";
    $stmt = $conn->prepare($update_balance_sql);
    $stmt->bind_param("si", $encryptedNewBalance, $user_id);
    $stmt->execute();

    // Update transaction status
    $update_status_sql = "UPDATE Dollar_card_buy_History SET Status = ? WHERE id = ?";
    $stmt = $conn->prepare($update_status_sql);
    $stmt->bind_param("si", $status, $id);
    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'User balance and status updated.']);
    
    // Get FCM token
    $getFcmSql = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmt = $conn->prepare($getFcmSql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $fcm_result = $stmt->get_result();

    if ($fcm_result->num_rows > 0) {
        $user_data = $fcm_result->fetch_assoc();
        $fcm_token = $user_data['FCM_Token'];

          if (!empty($fcm_token) && strlen($fcm_token) > 50) {
        $accessToken = getAccessToken('service-account-file.json');
        
             $title = "Calling Card buy Cancelled";
            $body  = "Your calling card buy transaction has been cancelled. ৳" . number_format($alpha_amount, 2) . " has been refunded to your balance.";

        $payload = json_encode([
            'message' => [
                'token' => $fcm_token,
                'data' => ['title' => $title, 'body' => $body]
            ]
        ]);

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $fcmResponse = curl_exec($ch);
        curl_close($ch);
      }
    }

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>