<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

require 'get-access-token.php';

try {
    $api_key = $_POST['api_key'] ?? '';
    $id = $_POST['id'] ?? '';
    $user_id = $_POST['idd'] ?? '';
    $status = $_POST['status'] ?? '';
    $encrypted_amount = $_POST['Amount'] ?? '';

    $conn->set_charset("utf8mb4");

    // Validate API key
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Decrypt and validate amount
    $amount = decryptData($encrypted_amount);
    if (!is_numeric($amount) || $amount <= 0) {
        throw new Exception("Invalid amount.");
    }

    // Check user verification and get FCM token
    $verifySql = "SELECT Veryfi_Status, FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmtVerify = $conn->prepare($verifySql);
    $stmtVerify->bind_param("i", $user_id);
    $stmtVerify->execute();
    $resultVerify = $stmtVerify->get_result();
    $stmtVerify->close();

    $userData = $resultVerify->fetch_assoc();
    /*if ($resultVerify->num_rows === 0) {
        throw new Exception("User not found.");
    }

    if ($userData['Veryfi_Status'] != 1) {
        throw new Exception("User account is not verified.");
    }*/

    // Check current transaction status
    $checkSql = "SELECT Status FROM Add_Money_History WHERE id = ?";
    $stmtCheck = $conn->prepare($checkSql);
    $stmtCheck->bind_param("i", $id);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();

    if ($resultCheck->num_rows === 0) {
        throw new Exception("Transaction not found.");
    }

    $currentStatus = strtolower($resultCheck->fetch_assoc()['Status']);
    $stmtCheck->close();

    if ($currentStatus === 'cancel') {
        echo json_encode(['status' => 'success', 'message' => 'Already cancelled, no update needed.']);
        exit;
    }

    // Update transaction status
    $updateSql = "UPDATE Add_Money_History SET Status = ? WHERE id = ?";
    $stmtUpdate = $conn->prepare($updateSql);
    $stmtUpdate->bind_param("si", $status, $id);
    $stmtUpdate->execute();
    $stmtUpdate->close();

//*****************************************************
    // Send FCM notification
    $fcm_token = $userData['FCM_Token'];
    if (strlen($fcm_token) < 100) {
        throw new Exception("Invalid FCM token.");
    }

    $accessToken = getAccessToken('service-account-file.json');

    $title = "Add Money Request Cancelled";
    $body = "Your add money request of ৳" . number_format($amount, 2) . " has been cancelled. If you have any questions, please contact our support team. Thank you.";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode(['message' => ['token' => $fcm_token, 'data' => $datamsg]]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        throw new Exception("FCM Send Error: " . curl_error($ch));
    }
    curl_close($ch);
    
    //****************************************************

    echo json_encode(['status' => 'success', 'message' => 'Transaction status updated and notification sent.']);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>