<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get User_ID
    $user_id = $input['User_ID'] ?? '';

    if (empty($user_id)) {
        throw new Exception('User ID is required.');
    }

    // Update `Block` column to 1 in `User_Database`
    $sql = "UPDATE USER_DATABSE_PIN SET Block = 1 WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'User blocked successfully.']);
    } else {
        throw new Exception('Failed to block user.');
    }

    $stmt->close();
} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
