<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $conn->set_charset("utf8mb4");
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Inputs
    $user_id = isset($input['User_ID']) ? trim($input['User_ID']) : null;
    $id      = isset($input['ID']) ? trim($input['ID']) : null;

    if (empty($user_id)) {
        throw new Exception('User ID is required.');
    }

    // -----------------------------------------
    // UPDATE USER BAN STATUS
    // -----------------------------------------
    $sql = "UPDATE USER_DATABSE_PIN 
            SET Ban_From_Add_money = 1 
            WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);

    if (!$stmt->execute()) {
        throw new Exception('Failed to update user status.');
    }
    $stmt->close();

    // -----------------------------------------
    // DELETE SPECIFIC Add_Money_History RECORD
    // -----------------------------------------
    if (!empty($id)) {
        $deleteSql = "DELETE FROM Add_Money_History WHERE id = ?";
        $stmtDelete = $conn->prepare($deleteSql);
        $stmtDelete->bind_param("i", $id);

        if (!$stmtDelete->execute()) {
            throw new Exception('Failed to delete add money history.');
        }

        if ($stmtDelete->affected_rows === 0) {
            throw new Exception('No record found to delete.');
        }

        $stmtDelete->close();
    }

    // -----------------------------------------
    // DELETE ALL PENDING TRANSACTIONS FOR USER
    // -----------------------------------------
    $deletePendingSql = "DELETE FROM Add_Money_History WHERE User_ID = ? AND Status = 'Pending'";
    $stmtDeletePending = $conn->prepare($deletePendingSql);
    $stmtDeletePending->bind_param("i", $user_id);

    if (!$stmtDeletePending->execute()) {
        throw new Exception('Failed to delete pending transactions.');
    }
    $stmtDeletePending->close();

    // -----------------------------------------
    // FETCH FCM TOKEN
    // -----------------------------------------
    $verifySql = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmtVerify = $conn->prepare($verifySql);
    $stmtVerify->bind_param("i", $user_id);
    $stmtVerify->execute();
    $resultVerify = $stmtVerify->get_result();
    $stmtVerify->close();

    if ($resultVerify->num_rows === 0) {
        throw new Exception("User not found or missing FCM token.");
    }

    $userData = $resultVerify->fetch_assoc();
    $fcm_token = $userData['FCM_Token'];

    if (empty($fcm_token) || strlen($fcm_token) < 100) {
        throw new Exception("Invalid FCM token.");
    }

    // -----------------------------------------
    // SEND FCM NOTIFICATION
    // -----------------------------------------
    $accessToken = getAccessToken('service-account-file.json');

    $title = "Ban From Add Money";
    $body  = "Your account has been banned from Add Money. Pending transactions have been deleted. Contact support to resolve.";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode([
        'message' => [
            'token' => $fcm_token,
            'data'  => $datamsg
        ]
    ]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        throw new Exception("FCM Send Error: " . curl_error($ch));
    }
    curl_close($ch);

    // -----------------------------------------
    // FINAL RESPONSE
    // -----------------------------------------
    echo json_encode([
        'status'  => 'success',
        'message' => 'User banned, add money history deleted, pending transactions removed, and notification sent successfully.'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
?>