<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// 🔐 Basic Auth check
if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW'])) {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['status' => 'error', 'message' => 'Missing credentials']);
    exit();
}

$validUser = 'otp_send_cheack_512';
$validPass = 'Jp4{+82F5Tf-';

if ($_SERVER['PHP_AUTH_USER'] !== $validUser || $_SERVER['PHP_AUTH_PW'] !== $validPass) {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['status' => 'error', 'message' => 'Access denied']);
    exit();
}

// 📦 Read JSON body
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

if (!$data) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON']);
    exit();
}

$phone     = $data['phone'] ?? '';
$password  = $data['password'] ?? '';
$fcmToken  = $data['fcm_token'] ?? '';

if (empty($phone) || empty($password)) {
    echo json_encode(['status' => 'error', 'message' => 'Phone or password missing']);
    exit();
}

// 🔍 Fetch admin with Block status
$stmt = $conn->prepare(
    "SELECT id, Password, Block 
     FROM Admin_Login 
     WHERE Phone_Number = ?"
);
$stmt->bind_param("s", $phone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {

    $row = $result->fetch_assoc();

    // 🚫 Block check
    if ((int)$row['Block'] === 1) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Your account is blocked. Please contact support.'
        ]);
        exit();
    }

    // 🔐 Password check (plain text)
    if ($row['Password'] === $password) {

        // ✅ Update FCM token if provided
        if (!empty($fcmToken)) {
            $update = $conn->prepare(
                "UPDATE Admin_Login SET FCM_Token = ? WHERE id = ?"
            );
            $update->bind_param("si", $fcmToken, $row['id']);
            $update->execute();
            $update->close();
        }

        echo json_encode([
            'status'   => 'success',
            'message'  => 'Login successful',
            'admin_id' => $row['id']
        ]);

    } else {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Incorrect password'
        ]);
    }

} else {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Phone number not found'
    ]);
}

$stmt->close();
$conn->close();
?>
