<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

// Step 1: Validate API Key
$encrypted_api_key = $_POST['api_key'] ?? '';
$api_key = decryptData($encrypted_api_key);

if ($api_key !== $valid_api_key) {
    echo json_encode(["status" => "error", "message" => "Invalid API key."]);
    exit();
}

// Step 2: Get Title and Image
$title = $_POST['title'] ?? '';
$root_amount = $_POST['root_amount'] ?? '';
$off_price = $_POST['off_price'] ?? '';
$link = $_POST['link'] ?? '';
$user_name = $_POST['user_name'] ?? '';

$passwordd = $_POST['password'] ?? '';
$vpn_app_link = $_POST['vpn_app_link'] ?? '';
$details = $_POST['details'] ?? '';






$encodedImage = $_POST['image'] ?? '';



// Check required fields
if (empty($title) || empty($encodedImage)) {
    echo json_encode(["status" => "error", "message" => "Title or Image missing."]);
    exit();
}

// Step 3: Decode and Save Image
$uploadDirectory = 'uploads/';
if (!is_dir($uploadDirectory) && !mkdir($uploadDirectory, 0777, true)) {
    echo json_encode(["status" => "error", "message" => "Failed to create upload directory."]);
    exit();
}

$imageData = base64_decode($encodedImage);
if ($imageData === false) {
    echo json_encode(["status" => "error", "message" => "Failed to decode image."]);
    exit();
}

$imageName = uniqid() . '.jpg';
$imagePath = $uploadDirectory . $imageName;
$imageUrl = 'https://akashpy.com/PIN_SHOP/PA/' . $imagePath;

if (!file_put_contents($imagePath, $imageData)) {
    echo json_encode(["status" => "error", "message" => "Failed to save image."]);
    exit();
}

// Step 4: Insert Into Database
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "Database connection failed: " . $conn->connect_error]);
    exit();
}
 $conn->set_charset("utf8mb4");

$sql = "INSERT INTO Vpn_Card (Title, Price, Price_OFF, Link, User_Name, Pasword, VPN_APP_link, Details, Image) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Prepare failed: " . $conn->error]);
    exit();
}

$stmt->bind_param("sssssssss", $title, $root_amount, $off_price, $link, $user_name, $passwordd, $vpn_app_link, $details, $imageUrl);
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Image and title inserted.", "image_url" => $imageUrl]);
} else {
    echo json_encode(["status" => "error", "message" => "Execute failed: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
