<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

try {
    date_default_timezone_set('Asia/Dhaka');
    $conn->set_charset("utf8mb4");

    // Validate API key
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Title and Message
    $title = trim($_POST['Title'] ?? '');
    $message = trim($_POST['Massage'] ?? '');
    if (empty($title) || empty($message)) {
        throw new Exception('Title and message are required.');
    }

    // Check for duplicate notice
    $checkSql = "SELECT 1 FROM Notice WHERE Title = ? AND Massage = ?";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->bind_param("ss", $title, $message);
    $checkStmt->execute();
    $checkStmt->store_result();
    if ($checkStmt->num_rows > 0) {
        throw new Exception('Duplicate notice already exists.');
    }
    $checkStmt->close();

    // Begin transaction
    $conn->begin_transaction();

    // Insert notice
    $date_time = date('Y-m-d H:i:s');
    $insertSql = "INSERT INTO Notice (Title, Massage, Date_Time) VALUES (?, ?, ?)";
    $insertStmt = $conn->prepare($insertSql);
    $insertStmt->bind_param("sss", $title, $message, $date_time);
    if (!$insertStmt->execute()) {
        throw new Exception('Failed to insert notice.');
    }
    $insertStmt->close();

    // Prepare FCM payload
    $accessToken = getAccessToken('service-account-file.json');
    $datamsg = ["title" => $title, "body" => $message];

    // Fetch valid FCM tokens
    $tokenQuery = "SELECT DISTINCT FCM_Token FROM USER_DATABSE_PIN WHERE FCM_Token IS NOT NULL AND FCM_Token != '' AND FCM_Token != '0'";
    $result = $conn->query($tokenQuery);
    if ($result->num_rows === 0) {
        throw new Exception('Notice added, but no valid FCM tokens found.');
    }

    $sendCount = 0;
    while ($row = $result->fetch_assoc()) {
        $fcm_token = $row['FCM_Token'];
        if (strlen($fcm_token) < 10) continue;

        $payload = json_encode(["message" => [
            "token" => $fcm_token,
            "data"  => $datamsg
        ]]);

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode === 200) {
            $sendCount++;
        } else {
            error_log("FCM failed for token $fcm_token: $response");
        }
    }

    $conn->commit();

    echo json_encode([
        'status' => 'success',
        'message' => "Notice added and sent to {$sendCount} user(s)."
    ]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
