<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Title and Message
    $methode = $_POST['Methode'] ?? '';
    $number = $_POST['Number'] ?? '';
    $type = $_POST['Type'] ?? '';
    
    
    
    

    if (empty($methode) || empty($number)||empty($type)  ) {
        throw new Exception('Title and message are required.');
    }

    // Insert notice into the database
    
    $sql = "INSERT INTO Add_money_Option (Methode_name, Number, Type ) VALUES (?, ?, ? )";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $methode, $number, $type );

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Mobile Details added successfully.']);
    } else {
        throw new Exception('Failed to add notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
