<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

$uploadDirectory = 'uploads/';

// Ensure the upload directory exists
if (!is_dir($uploadDirectory) && !mkdir($uploadDirectory, 0777, true)) {
    echo json_encode(["status" => "error", "message" => "Failed to create upload directory."]);
    exit();
}

// Step 1: Retrieve and validate API key
$encrypted_api_key = $_POST['api_key'] ?? '';
$api_key = decryptData($encrypted_api_key);

if ($api_key !== $valid_api_key) {
    echo json_encode(["status" => "error", "message" => "Invalid API key."]);
    exit();
}

// Step 2: Retrieve Image and Click URL
$encodedImage = $_POST['Image'] ?? '';
$clickUrl = $_POST['Click_link_Url'] ?? '';

if (empty($encodedImage) || empty($clickUrl)) {
    echo json_encode(["status" => "error", "message" => "Image or Click URL is missing."]);
    exit();
}

// Step 3: Decode Image and Save It
$imageData = base64_decode($encodedImage);
if ($imageData === false) {
    echo json_encode(["status" => "error", "message" => "Failed to decode image."]);
    exit();
}

$imageName = uniqid() . '.jpg';
$imagePath = $uploadDirectory . $imageName;
$imageUrl = 'https://akashpy.com/PIN_SHOP/PA/' . $imagePath;

if (!file_put_contents($imagePath, $imageData)) {
    echo json_encode(["status" => "error", "message" => "Failed to save image."]);
    exit();
}

// Step 4: Insert Into Database
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "Database connection failed: " . $conn->connect_error]);
    exit();
}

$sql = "INSERT INTO Image_Slider (Image, Click_link_Url) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Failed to prepare SQL statement: " . $conn->error]);
    exit();
}

$stmt->bind_param("ss", $imageUrl, $clickUrl);
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Image uploaded and record added.", "image_url" => $imageUrl]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert record: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
