<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Title and Message
    $image_Url = $_POST['Image_Url'] ?? '';
    $bank_addres = $_POST['Bank_addres'] ?? '';
    $bank_branch = $_POST['Bank_branch'] ?? '';
    $account_holdder = $_POST['Account_holdder'] ?? '';
    $bank_name = $_POST['Bank_name'] ?? '';
    $bank_account_number = $_POST['Bank_account_number'] ?? '';
    
    
    

    if (empty($image_Url) || empty($bank_addres)||empty($bank_branch) || empty($account_holdder)|| empty($account_holdder) || empty($bank_name)|| empty($bank_account_number)) {
        throw new Exception('Title and message are required.');
    }

    // Insert notice into the database
    
    $sql = "INSERT INTO Add_money_Bank_details (Bank_Account_number, Bank_Name, Bank_Holder_Name, Bank_Branch, bank_Address, Bank_image) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssss", $bank_account_number, $bank_name, $account_holdder, $bank_branch, $bank_addres, $image_Url);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Bank Details added successfully.']);
    } else {
        throw new Exception('Failed to add notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
