<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    $name     = trim($_POST['Name'] ?? '');
    $number   = trim($_POST['Phone_Number'] ?? '');
    $password = trim($_POST['Passwor'] ?? '');

    if (empty($name) || empty($number) || empty($password)) {
        throw new Exception('All fields are required.');
    }

    $block = "0";
    $fcm   = "0";

    $insertSql = "INSERT INTO Admin_Login 
        (Name, Phone_Number, Password, Block, FCM_Token) 
        VALUES (?, ?, ?, ?, ?)";

    // ✅ FIX HERE
    $stmt = $conn->prepare($insertSql);
    if (!$stmt) {
        throw new Exception($conn->error);
    }

    $stmt->bind_param("sssss", $name, $number, $password, $block, $fcm);

    if ($stmt->execute()) {
        echo json_encode([
            'status'  => 'success',
            'message' => 'Admin user added successfully.'
        ]);
    } else {
        throw new Exception('Failed to insert data.');
    }

    $stmt->close();

} catch (Exception $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
