<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Title and Message
    $user_name_ = $_POST['user_name'] ?? '';
    $mail = $_POST['Mail'] ?? '';
    
    
    
    
    

    if (empty($user_name_) || empty($mail)  ) {
        throw new Exception('Title and message are required.');
    }

    // Insert notice into the database
    
    $sql = "INSERT INTO Binance_add_money_details (gmail_ID, Account_user_Name  ) VALUES (?, ? )";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $mail, $user_name_ );

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Binance Details added successfully.']);
    } else {
        throw new Exception('Failed to add notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
