<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    $countryName     = trim($_POST['CountryName'] ?? '');
    $countryshortname   = trim($_POST['Countryshortname'] ?? '');
    $today_rate = trim($_POST['Today_rate'] ?? '');

    if (empty($countryName) || empty($countryshortname) || empty($today_rate)) {
        throw new Exception('All fields are required.');
    }
 
    $insertSql = "INSERT INTO Exchnage_Rate 
        (Country_Curency_Short_Test, Country_Name, Today_Rate) 
        VALUES (?, ?, ?)";

    // ✅ FIX HERE
    $stmt = $conn->prepare($insertSql);
    if (!$stmt) {
        throw new Exception($conn->error);
    }

    $stmt->bind_param("sss", $countryshortname, $countryName, $today_rate);

    if ($stmt->execute()) {
        echo json_encode([
            'status'  => 'success',
            'message' => 'added successfully.'
        ]);
    } else {
        throw new Exception('Failed to insert data.');
    }

    $stmt->close();

} catch (Exception $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
