<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // --- Validate API Key ---
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // --- Collect Inputs ---
    $today_rate        = $_POST['Today_rate'] ?? '';
    $limit_blance_admin_ = $_POST['limit_blance_admin'] ?? '';
    $available_usd_    = $_POST['available_usd'] ?? '';
    $limit_to_Buy_max_ = $_POST['limit_to_Buy_max'] ?? '';
    $bkash_            = $_POST['bkash'] ?? ''; 
    $nagad_            = $_POST['nagad'] ?? '';
    $rocket_           = $_POST['rocket'] ?? '';
    $cellfin_          = $_POST['cellfin'] ?? '';
    $bank_             = $_POST['bank'] ?? '';

    // --- Update Query (update row with id=1) ---
    $sql = "UPDATE Binance_Sell_details 
            SET USDT_Rate = ?, 
                Limite_Balance = ?, 
                Available_usdt = ?, 
                Limit_To_BUY_USDT = ?, 
                Bkash = ?, 
                Nagad = ?, 
                Rocket = ?, 
                Celfin = ?, 
                Bank = ?
            WHERE id = 1";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssss", 
        $today_rate, 
        $limit_blance_admin_, 
        $available_usd_, 
        $limit_to_Buy_max_, 
        $bkash_, 
        $nagad_, 
        $rocket_, 
        $cellfin_, 
        $bank_
    );

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Binance Buy Details updated successfully.']);
    } else {
        throw new Exception('Failed to update Binance Buy Details.');
    }

    $stmt->close();

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
