<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Notice from input
    $Minimum_Recharge = $input['Minimum_Recharge'] ?? '';
     $Max_recharge = $input['Max_recharge'] ?? '';
    
    
    
    if (empty($Minimum_Recharge)) {
        throw new Exception('Minimum_Recharge is required.');
    }

    $conn->set_charset("utf8mb4");

    // Update `Live_Notice` column in `App_Setting` table
    $sql = "UPDATE App_Setting SET Nagad_Minimum_Amount = ?, Nagad_Max_Amount = ? WHERE id = 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $Minimum_Recharge, $Max_recharge);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'updated successfully.']);
    } else {
        throw new Exception('Failed to update notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}