<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get Notice from input
    $notice = $input['Minimum_Recharge'] ?? '';
    
    if (empty($notice)) {
        throw new Exception('Data is required.');
    }

    $conn->set_charset("utf8mb4");

    // Update `Rocket_Send_money_Chage_Amount` column in `App_Setting` table
    $sql = "UPDATE App_Setting SET Rocket_Send_money_Chage_Amount = ? WHERE id = 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $notice);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'updated successfully.']);
    } else {
        throw new Exception('Failed to update notice.');
    }

    $stmt->close();
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}