<?php
header('Content-Type: application/json');
require_once 'connection.php';
require_once 'decryption_api_key.php';

require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

// Table name
$table_name = "USER_DATABSE_PIN";

// Step 1: Check if required POST parameters exist
if (!isset($_POST['phone'], $_POST['reffer_code'], $_POST['email'], $_POST['API_Key'])) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required parameters']);
    exit;
}

// Step 2: Validate API Key
$api_validation = validateApiKey($_POST['API_Key']);
if ($api_validation['status'] === false) {
    echo json_encode(['status' => 'error', 'message' => $api_validation['message']]);
    exit;
}

// Step 3: Decrypt incoming data
$phone = decryptData($_POST['phone']);
$reffer_code = decryptData($_POST['reffer_code']);
$email = decryptData($_POST['email']);

// Step 4: Check DB connection
if (!$conn || $conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Step 5: Check if email exists
$email_check_query = $conn->prepare("SELECT id FROM $table_name WHERE Email = ?");
$email_check_query->bind_param("s", $email);
$email_check_query->execute();
$email_check_query->store_result();

if ($email_check_query->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Email already exists']);
    $email_check_query->close();
    exit;
}
$email_check_query->close();

// Step 6: Check if phone number exists
$phone_check_query = $conn->prepare("SELECT id FROM $table_name WHERE Phone_number = ?");
$phone_check_query->bind_param("s", $phone);
$phone_check_query->execute();
$phone_check_query->store_result();

if ($phone_check_query->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Phone number already exists']);
    $phone_check_query->close();
    exit;
}
$phone_check_query->close();


// Step 8: If all checks pass
echo json_encode(['status' => 'success', 'message' => 'All checks passed. Proceed to OTP verification.']);

$conn->close();
?>
