<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

$requestData = json_decode(file_get_contents("php://input"), true);
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Check API key
if (!isset($requestData['api_key'])) {
    error_log("API Key Missing in Request!");
    echo json_encode(['status' => 'error', 'message' => 'API key missing']);
    exit();
}

error_log("Encrypted API Key Received: " . $requestData['api_key']);
$apiKeyValidation = validateApiKey($requestData['api_key']);
if (!$apiKeyValidation['status']) {
    error_log("API Key Validation Failed: " . json_encode($apiKeyValidation));
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Encrypted inputs
$encrypted_user_id      = $requestData['id'] ?? null;
$encrypted_amount       = $requestData['Amount'] ?? null;
$encrypted_methode      = $requestData['Methode'] ?? null;
$encrypted_trx_id       = $requestData['Trx_ID'] ?? null;
$encrypted_phone_number = $requestData['Phone_number'] ?? null;
$encrypted_contact      = $requestData['Contact'] ?? null;

// Validate presence
if (!$encrypted_user_id || !$encrypted_amount || !$encrypted_methode || !$encrypted_trx_id || !$encrypted_phone_number || !$encrypted_contact) {
    echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
    exit();
}

// Decrypt values
$user_id      = decryptData($encrypted_user_id);
$amount       = decryptData($encrypted_amount);
$methode      = decryptData($encrypted_methode);
$trx_id       = decryptData($encrypted_trx_id);
$phone_number = decryptData($encrypted_phone_number);
$contact      = decryptData($encrypted_contact);

error_log("Decrypted User ID: " . $user_id);
error_log("Decrypted Amount: " . $amount);
error_log("Decrypted Methode: " . $methode);
error_log("Decrypted Trx ID: " . $trx_id);
error_log("Decrypted Phone Number: " . $phone_number);

// Validate decrypted values
if (!$user_id || !$amount || !$trx_id || !is_numeric($amount) || $amount <= 0 || !is_numeric($phone_number) || strlen($phone_number) < 11 || !is_numeric($contact) || strlen($contact) < 11) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt required inputs']);
    exit();
}

// Fetch user status
$userSql = "SELECT Veryfi_Status, Ban_From_Add_money FROM USER_DATABSE_PIN WHERE id = ?";
$stmtUser = $conn->prepare($userSql);
$stmtUser->bind_param("i", $user_id);
$stmtUser->execute();
$resultUser = $stmtUser->get_result();
$stmtUser->close();

if ($resultUser->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

$userData = $resultUser->fetch_assoc();
$veryfi_status     = $userData['Veryfi_Status'];
$ban_add_money     = $userData['Ban_From_Add_money'];

if ($veryfi_status != 1) {
    echo json_encode(['status' => 'error', 'message' => 'Please verify your account before proceeding']);
    exit();
}

if ($ban_add_money == 1) {
    echo json_encode(['status' => 'error', 'message' => 'You are banned from adding money']);
    exit();
}

// Check duplicate transaction
$trxCheckSql = "SELECT Trx_ID FROM Add_Money_History WHERE Trx_ID = ?";
$stmtCheckTrx = $conn->prepare($trxCheckSql);
$stmtCheckTrx->bind_param("s", $trx_id);
$stmtCheckTrx->execute();
$trxCheckResult = $stmtCheckTrx->get_result();
$stmtCheckTrx->close();

if ($trxCheckResult->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Transaction ID already exists']);
    exit();
}

// Begin transaction
$conn->begin_transaction();

// Insert into history
$historyInsertSql = "INSERT INTO Add_Money_History (User_ID, Phone_number, Amount, Methode, Date, Status, Trx_ID, Contact_number)
                     VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

$stmtInsertHistory = $conn->prepare($historyInsertSql);
$status = "Pending";
$current_date = date("Y-m-d H:i:s");

$stmtInsertHistory->bind_param("isssssss", $user_id, $phone_number, $amount, $methode, $current_date, $status, $trx_id, $contact);

if ($stmtInsertHistory->execute()) {
    $conn->commit();
    echo json_encode(['status' => 'success', 'message' => 'Add money request submitted successfully']);
    // ðŸ”” Notify all admins via FCM
require 'get-access-token.php';

try {
    $adminTokenSql = "SELECT FCM_Token FROM Admin_Login WHERE LENGTH(FCM_Token) > 100";
    $adminTokenResult = $conn->query($adminTokenSql);

    if ($adminTokenResult->num_rows > 0) {
        $accessToken = getAccessToken('service-account-file.json');

        $title = "New Mobile Banking Add Money Request";
        $maskedPhone = substr($phone_number, -4); // last 4 digits for privacy
        $body = "à§³" . number_format($amount, 2) . " via {$methode} â€” Phone ending in {$maskedPhone}, TRX ID: {$trx_id}";

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        while ($adminRow = $adminTokenResult->fetch_assoc()) {
            $fcm_token = $adminRow['FCM_Token'];

            $payload = json_encode([
                'message' => [
                    'token' => $fcm_token,
                    'notification' => [
                        'title' => $title,
                        'body' => $body,
                    ]
                ]
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $fcmResponse = curl_exec($ch);
            if ($fcmResponse === FALSE) {
                error_log("FCM Send Error: " . curl_error($ch));
            } else {
                error_log("FCM Response: " . $fcmResponse);
            }

            curl_close($ch);
        }
    }
} catch (Exception $e) {
    error_log("FCM Notification Error: " . $e->getMessage());
}
} else {
    $conn->rollback();
    echo json_encode(['status' => 'error', 'message' => 'Failed to insert transaction']);
}

$stmtInsertHistory->close();
$conn->close();
?>
